<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\FlexApi\V1\Interaction;

use Twilio\Options;
use Twilio\Values;

abstract class InteractionChannelOptions {
    /**
     * @param array $routing Optional. The state of associated tasks.
     * @return UpdateInteractionChannelOptions Options builder
     */
    public static function update(array $routing = Values::ARRAY_NONE): UpdateInteractionChannelOptions {
        return new UpdateInteractionChannelOptions($routing);
    }
}

class UpdateInteractionChannelOptions extends Options {
    /**
     * @param array $routing Optional. The state of associated tasks.
     */
    public function __construct(array $routing = Values::ARRAY_NONE) {
        $this->options['routing'] = $routing;
    }

    /**
     * Optional. The state of associated tasks. If not specified, all tasks will be set to `wrapping`.
     *
     * @param array $routing Optional. The state of associated tasks.
     * @return $this Fluent Builder
     */
    public function setRouting(array $routing): self {
        $this->options['routing'] = $routing;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.UpdateInteractionChannelOptions ' . $options . ']';
    }
}